package mobvista.dmp.function

import com.googlecode.aviator.runtime.function.AbstractFunction
import org.apache.commons.lang.StringUtils

abstract class CommonFunction extends AbstractFunction {
  val DATA_SPLIT = "\t"

  def splitFun(line : String, split : String) : Array[String] = {
    if (split == null) {
      StringUtils.splitPreserveAllTokens(line, DATA_SPLIT, -1)
    } else {
      StringUtils.splitPreserveAllTokens(line, split, -1)
    }
  }

  def splitFun(line : String) : Array[String] = {
    splitFun(line, null)
  }
}
