package mobvista.dmp.main

import org.apache.hadoop.conf.Configuration
import org.apache.spark.sql.catalyst.ScalaReflection
import org.apache.spark.sql.types.StructType

/**
  * @package: mobvista.dmp.main
  * @author: wangjf
  * @date: 2020/4/20
  * @time: 6:09 下午
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
object Constant {

  val packageRegex = "^[0-9]+$"

  abstract class Base extends Serializable with Product

  case class Tracking3S(device_id: String, device_type: String, platform: String, package_name: String, update_date: String, country: String)
    extends Base

  case class AdnInstall(device_id: String, device_type: String, platform: String, campaign_id: String, package_name: String)
    extends Base

  case class AdnRequestSdk(device_id: String, device_type: String, platform: String, app_id: String, package_name: String, update_date: String, model: String, brand: String,
                           os_version: String, country: String, strategy: String, region: String, dev_tag: Int)
    extends Base

  case class DspReq(device_id: String, device_type: String, platform: String, country_code: String, ip: String, gender: String, birthday: String, maker: String, model: String,
                    os_version: String, package_name: String, androidids: String, datetime: String, segment_ids: String, region: String)
    extends Base

  case class GA(device_id: String, device_type: String, platform: String, package_name: String, store_link: String)
    extends Base

  object BaseEncoder {
    implicit def baseEncoder: org.apache.spark.sql.Encoder[Base] = org.apache.spark.sql.Encoders.kryo[Base]
  }

  def getSchema(business: String): StructType = {
    import org.apache.spark.sql.catalyst.ScalaReflection
    val schema = business match {
      case "3s" =>
        ScalaReflection.schemaFor[Tracking3S].dataType.asInstanceOf[StructType]
      case "adn_request_sdk" =>
        ScalaReflection.schemaFor[AdnRequestSdk].dataType.asInstanceOf[StructType]
      case "adn_install" =>
        ScalaReflection.schemaFor[AdnInstall].dataType.asInstanceOf[StructType]
      case "dsp" =>
        ScalaReflection.schemaFor[DspReq].dataType.asInstanceOf[StructType]
    }
    schema
  }

  def initConfig(business: String, conf: Configuration): Configuration = {
    val schema = business match {
      case "3s" =>
        ScalaReflection.schemaFor[Tracking3S].dataType.asInstanceOf[StructType]
      case "adn_request_sdk" =>
        ScalaReflection.schemaFor[AdnRequestSdk].dataType.asInstanceOf[StructType]
      case "adn_install" =>
        ScalaReflection.schemaFor[AdnInstall].dataType.asInstanceOf[StructType]
      case "dsp" =>
        ScalaReflection.schemaFor[DspReq].dataType.asInstanceOf[StructType]
    }

    conf.set("orc.mapred.output.schema", schema.simpleString)
    conf.setBoolean("mapreduce.output.compress", true)
    conf.set("mapreduce.output.compression.codec", "com.hadoop.compression.lzo.LzoCodec")
    conf.setBoolean("mapreduce.output.fileoutputformat.compress", true)
    conf.set("mapreduce.output.fileoutputformat.compress.type", "com.hadoop.compression.lzo.LzoCodec")
    conf.set("orc.compress", "ZLIB")
    conf
  }
}
