package mobvista.dmp.test

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

import scala.collection.mutable.ArrayBuffer

class GaRepairInstallList extends CommonInstallList {

  /**
    * 解析天处理结果数据
    * @param array
    * @param date
    * @return
    */
  def processDailyData(array : Array[String], date : String): Array[Tuple2[String, InstallInfo]] = {
    val buffer = new ArrayBuffer[Tuple2[String, InstallInfo]]()
    val device_id = array(0)
    val device_type = array(1)
    var platform = array(2)
    val packageName = array(3)
    val date = array(5)

    if ("adr".equals(platform)) {
      platform = "android"
    }
    buffer += Tuple2(s"$device_id$DATA_SPLIT${device_type}${DATA_SPLIT}${platform}", new InstallInfo(packageName, date))
    buffer.toArray
  }
}

object GaRepairInstallList {
  def main(args: Array[String]): Unit = {
    new GaRepairInstallList().run(args)
  }
}