package com.reyun.wandun;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import me.weishu.reflection.Reflection;

public class WdMain {
    private static WdMain mInstance = new WdMain();

    // 用户申请sdk后获得的认证码，调用sdk接口时需传入
    private String mApiKey;

    //生成的唯一id
    private String mWdId;

    //app context
    private Context mContext;

    public static WdMain getInstance(){
        return mInstance;
    }

    //初始化方法，
    public void init(Context context, String apiKey) {
        mContext = context;
        mApiKey = apiKey;

        //access hidden api above android 9.0+
        Reflection.unseal(context);

        //load native lib
        System.loadLibrary("wdun");
        initNative(context);

        //todo 监控传感器数据变化
        //todo 监控手机信号强度变化
    }

    //获取wdId
    public void getWdId(WdCallback cb) {
        ExecutorService es = Executors.newSingleThreadExecutor();
        es.execute(new Runnable() {
            @Override
            public void run() {
                String wdId;
                //文件中读取
                SharedPreferences sp = mContext.getSharedPreferences("wd_dna", Context.MODE_PRIVATE);
                wdId =  sp.getString(MdUtils.md5("device_id"), null);
                if(wdId == null) {
                    //重新请求服务器获取
                    wdId = getWdIdNative();
                }
                cb.onWdId(wdId);
            }
        });
        es.shutdown();
    }

    public native void initNative(Context context);

    //native层获取wdId
    public native String getWdIdNative();


}
